/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.COSObjectable;

public class PDLineDashPattern
implements COSObjectable,
Cloneable {
    private static final Log LOG = LogFactory.getLog(PDLineDashPattern.class);
    private COSArray lineDashPattern = null;

    public PDLineDashPattern() {
        this.lineDashPattern = new COSArray();
        this.lineDashPattern.add(new COSArray());
        this.lineDashPattern.add(COSInteger.ZERO);
    }

    public PDLineDashPattern(COSArray ldp) {
        this.lineDashPattern = ldp;
    }

    public PDLineDashPattern(COSArray ldp, int phase) {
        this.lineDashPattern = new COSArray();
        this.lineDashPattern.add(ldp);
        this.lineDashPattern.add(COSInteger.get(phase));
    }

    public Object clone() {
        PDLineDashPattern pattern = null;
        try {
            pattern = (PDLineDashPattern)super.clone();
            pattern.setDashPattern(this.getDashPattern());
            pattern.setPhaseStart(this.getPhaseStart());
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Object)e, (Throwable)e);
        }
        return pattern;
    }

    @Override
    public COSBase getCOSObject() {
        return this.lineDashPattern;
    }

    public int getPhaseStart() {
        COSNumber phase = (COSNumber)this.lineDashPattern.get(1);
        return phase.intValue();
    }

    public void setPhaseStart(int phase) {
        this.lineDashPattern.set(1, phase);
    }

    public List getDashPattern() {
        COSArray dashPatterns = (COSArray)this.lineDashPattern.get(0);
        return COSArrayList.convertIntegerCOSArrayToList(dashPatterns);
    }

    public COSArray getCOSDashPattern() {
        return (COSArray)this.lineDashPattern.get(0);
    }

    public void setDashPattern(List dashPattern) {
        this.lineDashPattern.set(0, COSArrayList.converterToCOSArray(dashPattern));
    }

    public boolean isDashPatternEmpty() {
        float[] dashPattern = this.getCOSDashPattern().toFloatArray();
        boolean dashPatternEmpty = true;
        if (dashPattern != null) {
            int arraySize = dashPattern.length;
            for (int i = 0; i < arraySize; ++i) {
                if (!(dashPattern[i] > 0.0f)) continue;
                dashPatternEmpty = false;
                break;
            }
        }
        return dashPatternEmpty;
    }
}

